<?php          
/**
 * Configuration of all colors customizable. Follow the default scheme already written.
 * Replace all string uppercased.
 * 
 * This add automatically the options on Theme Options and generate the custom css
 * with all colors set by user, including it on theme.    
 * 
 * @package WordPress
 * @subpackage Kassyopea
 * @since 1.0 
 */   

//array of all colors customizable by user
$yiw_colors = array(
    'logo' => array(    // replace ID-SECTION with the id of the section (don't use space, only "-" for the space)
        'name-section' => __( 'Logo', 'yiw' ),   // replace TITLE OF SECTION with the title of the section
        'options' => array(
    
            'logo-color' => array(    // replace ID-OPTION with the id of this option (don't use space, only "-" for the space) 
                'default'     => '#615C5C',   // the default color, selected if the user doesn't set any color
                'css_role'    => '#logo h1 a',       // the roles of this color option, used when generating the css style
                'css_attr'    => 'color',   // the attribute used for the role
                'panel_title' => __( "Logo color", 'yiw' ),   // the title of option for Theme Options
                'panel_desc'  => __( "Select the color of the logo. (default #615C5C)", 'yiw' )  // the description of option for Theme Options
            ),

            'logo-color-hover' => array(
                'default' => '#57595C',
                'css_role' => '#logo h1 a:hover',
                'css_attr' => 'color',
                'panel_title' => __( "Logo color (hover effect)", 'yiw' ),
                'panel_desc' => __( "Select the color of the logo when the hover event is triggered. (default #57595C)", 'yiw' )
            ),          
        
        ),
    ),
    
    'nav' => array(    // replace ID-SECTION with the id of the section (don't use space, only "-" for the space)
        'name-section' => __( 'Main Menu', 'yiw' ),   // replace TITLE OF SECTION with the title of the section
        'options' => array(
    
            'nav-color' => array(    // replace ID-OPTION with the id of this option (don't use space, only "-" for the space) 
                'default'     => '#939393',   // the default color, selected if the user doesn't set any color
                'css_role'    => '#nav a',       // the roles of this color option, used when generating the css style
                'css_attr'    => 'color',   // the attribute used for the role
                'panel_title' => __( "List Items color", 'yiw' ),   // the title of option for Theme Options
                'panel_desc'  => __( "Select the color of each item in main menu. (default #939393)", 'yiw' )  // the description of option for Theme Options
            ),

            'nav-color-hover' => array(
                'default' => '#383737',
                'css_role' => '#nav a:hover, #nav .current-menu-item a',
                'css_attr' => 'color',
                'panel_title' => __( "List Items color (hover effect)", 'yiw' ),
                'panel_desc' => __( "Select the color of each item in main menu when the hover event is triggered. (default #373737)", 'yiw' )
            ),          
        
        ),
    ),
    
    'headings' => array(
        'name-section' => __( 'Headings', 'yiw' ),  
        'options' => array(
    
            'h1' => array( 
                'default'     => '#615C5C', 
                'css_role'    => 'h1', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Heading 1", 'yiw' ), 
                'panel_desc'  => __( "Select the color for Heading 1 items. (default #615C5C)", 'yiw' ) 
            ),         

            'h2' => array( 
                'default'     => '#615C5C', 
                'css_role'    => 'h2, .post_title h2', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Heading 2", 'yiw' ), 
                'panel_desc'  => __( "Select the color for Heading 2 items. (default #615C5C)", 'yiw' ) 
            ),         

            'h3' => array( 
                'default'     => '#615C5C', 
                'css_role'    => 'h3', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Heading 3", 'yiw' ), 
                'panel_desc'  => __( "Select the color for Heading 3 items. (default #615C5C)", 'yiw' ) 
            ),         

            'h4' => array( 
                'default'     => '#615C5C', 
                'css_role'    => 'h4', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Heading 4", 'yiw' ), 
                'panel_desc'  => __( "Select the color for Heading 4 items. (default #615C5C)", 'yiw' ) 
            ),         

            'h5' => array( 
                'default'     => '#615C5C', 
                'css_role'    => 'h5', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Heading 5", 'yiw' ), 
                'panel_desc'  => __( "Select the color for Heading 5 items. (default #615C5C)", 'yiw' ) 
            ),         

            'h6' => array( 
                'default'     => '#615C5C', 
                'css_role'    => 'h6', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Heading 6", 'yiw' ), 
                'panel_desc'  => __( "Select the color for Heading 6 items. (default #615C5C)", 'yiw' ) 
            ),         
        ),
    ),
    
    
    'slogan' => array(
        'name-section' => __( 'Slogan', 'yiw' ),  
        'options' => array(
    
            'slogan' => array( 
                'default'     => '#615C5C', 
                'css_role'    => '#slogan h1', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Slogan", 'yiw' ), 
                'panel_desc'  => __( "Select the color for slogan. (default #615C5C)", 'yiw' ) 
            ),         

            'subslogan' => array( 
                'default'     => '#939393', 
                'css_role'    => '#slogan h3', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Links", 'yiw' ), 
                'panel_desc'  => __( "Select the color for links. (default #939393)", 'yiw' ) 
            ),
        ),
    ),


    'paragraphs' => array(
        'name-section' => __( 'Paragraphs and links', 'yiw' ),  
        'options' => array(
    
            'p' => array( 
                'default'     => '#545252', 
                'css_role'    => 'p, #content .contact-form label, #content .contact-form input, #content .contact-form textarea', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Paragraphs", 'yiw' ), 
                'panel_desc'  => __( "Select the color for paragraphs. (default #545252)", 'yiw' ) 
            ),         

            'a' => array( 
                'default'     => '#D77002', 
                'css_role'    => '#content a, #footer a, #sidebar a, #sidebar .widget a, #footer .widget a, #copyright a, #footer .last-tweets a', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Links", 'yiw' ), 
                'panel_desc'  => __( "Select the color for links. (default #D77002)", 'yiw' ) 
            ),         

            'a_hover' => array( 
                'default'     => '#000', 
                'css_role'    => '#content a:hover, #footer a:hover, #sidebar a:hover, #sidebar .widget a:hover, #footer .widget a:hover, #copyright a:hover, #footer .last-tweets a:hover', 
                'css_attr'    => 'color', 
                'panel_title' => __( "Links (hover effect)", 'yiw' ), 
                'panel_desc'  => __( "Select the color for links (hover effect). (default #000)", 'yiw' ) 
            ),
        ),
    ),

);    
    
$default_images = array(
    'gradient-home-section'	=> "bg/gradient-home-section.png",
    'home-section-bg'		=> "bg/home-section-bg.png",     
    'pag-slider'			=> "bg/pag-slider.png",
    'logo'					=> "logo.png"
);

?>