<?php
/**
 * All cufon replaces. Add here all fonts replaces
 * 
 * @package WordPress
 * @subpackage YIW Themes
 * @since 1.0 
 */       
 
// the roles to apply the special font choosen
define( 'YIW_ROLES_FONT', 'h1, h2, h3, h4, h5, h6, .special-font' );

// all fonts type
$yiw_fonts = array(
    array(
        'id_option' => 'font_logo',
        'css_role' => '#logo h1',
    ),
    array(
        'id_option' => 'font_p',
        'css_role' => 'p',
    ),
    array(
        'id_option' => 'font_nav',
        'css_role' => '#nav > ul > li > a, #nav > .menu > ul > li > a',
    ), 
    array(
        'id_option' => 'font_subnav',
        'css_role' => '#nav ul.sub-menu li a, #nav ul.children li a',
    ),
    array(
        'id_option' => 'font_h1',
        'css_role' => 'h1',
    ),       
    array(
        'id_option' => 'font_h2',
        'css_role' => 'h2',
    ),       
    array(
        'id_option' => 'font_h3',
        'css_role' => 'h3, #content .hentry h4, .box-sections h6, .box-sections-border h6,  .box-sections h3, .box-sections-border h3, #content .hentry .box-sections-border h4, #content .hentry .box-sections h4',
    ),       
    array(
        'id_option' => 'font_h4',
        'css_role' => 'h4, #footer .widget h3, #footer .widget h2,  #logo h2',
    ),       
    array(
        'id_option' => 'font_h5',
        'css_role' => 'h5', 
    ),       
    array(
        'id_option' => 'font_h6',
        'css_role' => 'h6',
    ),       
    array(
        'id_option' => 'font_slogan',
        'css_role' => '#slogan h1',
    ),       
    array(
        'id_option' => 'font_subslogan',
        'css_role' => '#slogan h3',
    ),       
);

// array of all fonts size customizable by user
$yiw_sizes = array(
    'general' => array(    
        'name-section' => __( 'General', 'yiw' ),  
        'options' => array(
            'nav-size' => array(    
                'default' => 10,     
                'css_role' => '#nav > ul > li > a, #nav .menu > ul > li > a',
                'css_attr' => 'font-size',
                'panel_title' => __( "Navigation text", 'yiw' ),   
                'panel_desc' => __( "Size of the navigation links.", 'yiw' ) 
            ),
            
            'subnav-size' => array(    
                'default' => 11,     
                'css_role' => '#nav ul.sub-menu li a, #nav ul.children li a',   
                'css_attr' => 'font-size',
                'panel_title' => __( "Sub Navigation text", 'yiw' ),   
                'panel_desc' => __( "Size of the sub navigation links.", 'yiw' ) 
            ),
    
            'text-size' => array(    
                'default' => 12,     
                'css_role' => 'p',   
                'css_attr' => 'font-size',
                'panel_title' => __( "General text", 'yiw' ),   
                'panel_desc' => __( "Size of the general text paragraphs.", 'yiw' ) 
            ),
    
            'h1-size' => array(    
                'default' => 26,     
                'css_role' => 'h1',   
                'css_attr' => 'font-size',
                'panel_title' => __( "H1 headline", 'yiw' ),   
                'panel_desc' => __( "Size of the H1 elements.", 'yiw' ) 
            ),
    
            'h2-size' => array(    
                'default' => 24,     
                'css_role' => 'h2',   
                'css_attr' => 'font-size',
                'panel_title' => __( "H2 headline", 'yiw' ),   
                'panel_desc' => __( "Size of the H2 elements.", 'yiw' ) 
            ),   
    
            'h3-size' => array(    
                'default' => 24,     
                'css_role' => 'h3',   
                'css_attr' => 'font-size',
                'panel_title' => __( "H3 headline", 'yiw' ),   
                'panel_desc' => __( "Size of the H4 elements.", 'yiw' ) 
            ),    
    
            'h4-size' => array(    
                'default' => 12,     
                'css_role' => 'h4',   
                'css_attr' => 'font-size',
                'panel_title' => __( "H4 headline", 'yiw' ),   
                'panel_desc' => __( "Size of the H4 elements.", 'yiw' ) 
            ),    
    
            'h5-size' => array(    
                'default' => 12,     
                'css_role' => 'h5',   
                'css_attr' => 'font-size',
                'panel_title' => __( "H5 headline", 'yiw' ),   
                'panel_desc' => __( "Size of the H5 elements.", 'yiw' ) 
            ),     
    
            'h6-size' => array(    
                'default' => 12,     
                'css_role' => 'h6',   
                'css_attr' => 'font-size',
                'panel_title' => __( "H6 headline", 'yiw' ),   
                'panel_desc' => __( "Size of the H6 elements.", 'yiw' ) 
            ),
        
            'slogan-size' => array(    
                'default' => 26,     
                'css_role' => '#slogan h1',   
                'css_attr' => 'font-size',
                'panel_title' => __( "Slogan", 'yiw' ),   
                'panel_desc' => __( "Size of the Slogan elements.", 'yiw' ) 
            ),
        
            'subslogan-size' => array(    
                'default' => 18,     
                'css_role' => '#slogan h3',   
                'css_attr' => 'font-size',
                'panel_title' => __( "Sub Slogan", 'yiw' ),   
                'panel_desc' => __( "Size of the Sub Slogan elements.", 'yiw' ) 
            ),
        
        ),
        
    ),
); 
?>