<?php
/**
 * Additional shortcodes for the theme.
 *
 * To create new shortcode, get for example the shortcode [sample] already written.
 * Replace it with your code for shortcode and for other shortcodes, duplicate the first
 * and continue following.
 *
 * CONVENTIONS:
 * - The name of function MUST be: yiw_sc_SHORTCODENAME_func.
 * - All html output of shortcode, must be passed by an hook: apply_filters( 'yiw_sc_SHORTCODENAME_html', $html ).
 * NB: SHORTCODENAME is the name of shortcode and must be written in lowercase.
 *
 * For example, we'll add new shortcode [sample], so:
 * - the function must be: yiw_sc_sample_func().
 * - the hooks to use will be: apply_filters( 'yiw_sc_sample_html', $html ).
 *
 * @package WordPress
 * @subpackage YIW Themes
 * @since 1.0
 */

/**
 * SAMPLE
 *
 * @description
 *    description of sample shortcode
 *
 * @example
 *   [sample title="" incipit="" phone="" [class=""]]
 *
 * @attr
 *   class (optional) - class of container of box call to action (optional) @default: 'call-to-action'
 *   href  - url of button
 *   title  - the title of call to action
 *   incipit - the text below title
**/
function yiw_sc_sample_func($atts, $content = null)
{
    extract(shortcode_atts(array(
        'class' => 'call-to-action',
        'title' => null,
        'incipit' => null,
        'phone' => null
    ), $atts));

    $html = ''; // this is the var to use for the html output of shortcode

    return apply_filters( 'yiw_sc_sample_html', $html );   // this must be written for each shortcode
}
add_shortcode('sample', 'yiw_sc_sample_func');



/**
 * testimonials
 *
 * @description
 *    Show all post on testimonials post types
 *
 * @example
 *   [testimonials items=""]
 *
 * @params
 *      items - number of item to show
 *
**/
function yiw_sc_testimonials_func($atts, $content = null) {
    extract(shortcode_atts(array(
        "items" => null
    ), $atts));

    wp_reset_query();

    $args = array(
        'post_type' => 'bl_testimonials'
    );

    $args['posts_per_page'] = ( !is_null( $items ) ) ? $items : -1;

    $tests = new WP_Query( $args );

    $html = '';
    if( !$tests->have_posts() ) return $html;

    //loop
    $html = '';
    while( $tests->have_posts() ) : $tests->the_post();

        $title = the_title( '<span class="title">', '</span>', false );
        $website = get_post_meta( get_the_ID(), '_testimonial_website', true );
        $label = get_post_meta( get_the_ID(), '_testimonial_label', true ) ? get_post_meta( get_the_ID(), '_testimonial_label', true ) : str_replace('http://', '', $website);
        $website = "<a href=\"" . esc_url( $website ) . "\">". $label  ."</a>";

        $html .= '<div class="testimonials-list group">';

        $html .= '  <div class="thumb-testimonial group">';
        $html .= '      ' . get_the_post_thumbnail( null, 'thumb_testimonial' );
        //$html .= '      <div class="shadow-thumb"></div>';
        $html .= '      <p class="name-testimonial group">' . $title . '<br /><span class="website">' . $website . '</span></p>';
        $html .= '  </div>';

        $content = apply_filters( 'the_content', get_the_content() );

        $html .= '  <div class="the-post group">';
        $html .= '      ' . $content;
        $html .= '  </div>';

        $html .= '</div>';

    endwhile;

    return apply_filters( 'yiw_sc_testimonials_html', $html );
}
add_shortcode("testimonials", "yiw_sc_testimonials_func");


/**
 * News
 *
 * @description
 *    Show all post of news post types
 *
 * @example
 *   [news_post items="" length=""]
 *
 * @params
 *      items - number of item to show
 *
**/
function news_post_func($atts, $content = null) {
    extract(shortcode_atts(array(
        "items" => -1,
        "length" => 25
    ), $atts));

    wp_reset_query();

    $args = array(
        'post_type' => 'bl_news',
        'posts_per_page' => $items
    );

    $tests = new WP_Query( $args );

    $html = '';
    if ( !$tests->have_posts() )
        return $html;

    //loop
    $html = '';
    while ( $tests->have_posts() ) : $tests->the_post();

        $html .= '<div class="news-list group">';

        $html .= '  <div class="thumb-news group">';
        $html .= '      ' . get_the_post_thumbnail( null, 'thumb_news' );
        $html .= '  </div>';

        $html .= '  <div class="the-post group">';
        $html .= '      <h3>'. get_the_title() .'</h3>';
        $html .= '      <p class="news-date">'. get_the_date() .'</p>';
        $html .= '      ' . yiw_content( $length, ' ' . __( 'Read more', 'yiw' ) );
        $html .= '  </div>';
        $html .= '</div>';

    endwhile;

    return $html;
}
add_shortcode("news_post", "news_post_func");



?>